# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdtexture import *
from .sdvalue import *
from .sdapiobject import *
from .sdtexture import *
from .sdapiobject import *
from .apiexception import APIException

class SDValueTexture(SDValue):
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDValueTexture
        """
        super(SDValueTexture, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(sdTexture : SDTexture) -> Optional[SDValueTexture]:
        """
        Create a new SDValueTexture from a SDTexture

        :param sdTexture: The SDTexture value to set
        """
        outSDValueTexture = ctypes.c_void_p()
        _res = sd.getContext().SDValueTexture_sNew(sdTexture.mHandle, ctypes.byref(outSDValueTexture))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outSDValueTexture, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outSDValueTexture.value, ownHandle=True)

    def get(self) -> Optional[SDTexture]:
        """
        Get the value as SDTexture

        """
        outSDTexture = ctypes.c_void_p()
        _res = self.mAPIContext.SDValueTexture_get(self.mHandle, ctypes.byref(outSDTexture))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outSDTexture, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outSDTexture.value, ownHandle=True)

